/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes.internal;

import cofh.lib.api.inventory.IItemStackHolder;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fluids.FluidStack;

public class DisenchantMachineRecipe
extends BaseMachineRecipe {
    public DisenchantMachineRecipe(int energy, float experience) {
        super(energy, experience);
    }

    public DisenchantMachineRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
        super(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
    }

    private int getEnchantmentXp(ItemStack stack) {
        int encXP = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            encXP += enchantment.m_6183_(level);
        }
        return encXP;
    }

    @Override
    public float getXp(IMachineInventory inventory) {
        int encXP = 0;
        for (IItemStackHolder iItemStackHolder : inventory.inputSlots()) {
            encXP += this.getEnchantmentXp(iItemStackHolder.getItemStack());
        }
        return (float)encXP + this.experience * inventory.getMachineProperties().getXpMod();
    }
}

